function dummyOptions(theSelect, options, dropowntext) {
    options = document.createElement("option");
    options.value = "";

    options.disabled = false;
    options.selected = false;
    theSelect.add(options);
    options.text = "SELECT " + dropowntext;
}

function getSelectValues(flag, selectVar) {
    var result = "";
    var options = selectVar && selectVar.options;
    var opt;

    for (var i = 0, iLen = options.length; i < iLen; i++) {
        opt = options[i];
        if (flag == '') {
            if (opt.selected) {
                result += opt.text;
            }
        }
        if (flag == "multiple") {
            if (opt.selected) {
                result += opt.text + "|";
            }
        }
    }
    return result.trim();
}

function loadDataDropdown(selectName, results) {
    var theSelect = document.getElementById(selectName);

    var options = theSelect.getElementsByTagName("option");
    theSelect.innerHTML = "";

    if (selectName == "semester") dummyOptions(theSelect, options, "SEMESTER");
    if (selectName == "subjectName") dummyOptions(theSelect, options, "SUBJECT");

    for (var i = 0; i < results.length; i++) {
        options = document.createElement("option");
        if (selectName.includes("semester")) {
            options.value = options.text = results[i].semesterValue.toUpperCase();
            theSelect.add(options);
        } else if (selectName.includes("subjectName")) {
            options.value = options.text = results[i].subjectName.toUpperCase();
            theSelect.add(options);
        }
    }
    return;
}

function reAnd(value) {
    return value.replace(/&/g, '/n')
}

function generateInvoicePdf(accountsId,semester,subjectName,unitNo,finalAmount,sr,plannedTime,approvedTime)
{
    var finalAmountInString=ConvertNumberToWords(finalAmount);
    document.getElementById('successMessage'+sr).innerHTML = 'Invoice Generated Successfully.';
    window.open("generateInvoicePdf.php?aId=" + accountsId + "&fAIS="+finalAmountInString+ "&sem=" + semester + "&sN=" + reAnd(subjectName.trim()) +  "&unitNo=" + unitNo + "&fA="+finalAmount + "&pT=" + plannedTime + "&aT=" + approvedTime);
    location.reload();
}

function ConvertNumberToWords(number) {
    var words = new Array();
    words[0] = '';
    words[1] = 'One';
    words[2] = 'Two';
    words[3] = 'Three';
    words[4] = 'Four';
    words[5] = 'Five';
    words[6] = 'Six';
    words[7] = 'Seven';
    words[8] = 'Eight';
    words[9] = 'Nine';
    words[10] = 'Ten';
    words[11] = 'Eleven';
    words[12] = 'Twelve';
    words[13] = 'Thirteen';
    words[14] = 'Fourteen';
    words[15] = 'Fifteen';
    words[16] = 'Sixteen';
    words[17] = 'Seventeen';
    words[18] = 'Eighteen';
    words[19] = 'Nineteen';
    words[20] = 'Twenty';
    words[30] = 'Thirty';
    words[40] = 'Forty';
    words[50] = 'Fifty';
    words[60] = 'Sixty';
    words[70] = 'Seventy';
    words[80] = 'Eighty';
    words[90] = 'Ninety';
    number = number.toString();
    var atemp = number.split(".");
    var number = atemp[0].split(",").join("");
    var n_length = number.length;
    var words_string = "";
    if (n_length <= 9) {
        var n_array = new Array(0, 0, 0, 0, 0, 0, 0, 0, 0);
        var received_n_array = new Array();
        for (var i = 0; i < n_length; i++) {
            received_n_array[i] = number.substr(i, 1);
        }
        for (var i = 9 - n_length, j = 0; i < 9; i++ , j++) {
            n_array[i] = received_n_array[j];
        }
        for (var i = 0, j = 1; i < 9; i++ , j++) {
            if (i == 0 || i == 2 || i == 4 || i == 7) {
                if (n_array[i] == 1) {
                    n_array[j] = 10 + parseInt(n_array[j]);
                    n_array[i] = 0;
                }
            }
        }
        value = "";
        for (var i = 0; i < 9; i++) {
            if (i == 0 || i == 2 || i == 4 || i == 7) {
                value = n_array[i] * 10;
            } else {
                value = n_array[i];
            }
            if (value != 0) {
                words_string += words[value] + " ";
            }
            if ((i == 1 && value != 0) || (i == 0 && value != 0 && n_array[i + 1] == 0)) {
                words_string += "Crores ";
            }
            if ((i == 3 && value != 0) || (i == 2 && value != 0 && n_array[i + 1] == 0)) {
                words_string += "Lakhs ";
            }
            if ((i == 5 && value != 0) || (i == 4 && value != 0 && n_array[i + 1] == 0)) {
                words_string += "Thousand ";
            }
            if (i == 6 && value != 0 && (n_array[i + 1] != 0 && n_array[i + 2] != 0)) {
                words_string += "Hundred and ";
            } else if (i == 6 && value != 0) {
                words_string += "Hundred ";
            }
        }
        words_string = words_string.split(" ").join(" ");
    }
    return words_string;
}

function showDetails(paymentId)
{
    encodedValue_paymentId = btoa(paymentId);
    encodedKey_pId = btoa('pId');
    console.log(encodedKey_pId);
    // window.location.href = "viewPaymentDetails.php?pId=" + paymentId;
    window.location.href = "viewPaymentDetails.php?" + encodedKey_pId + "=" + encodedValue_paymentId;
}

function filterOtherDropDown(flag)
{
    tempSemester = getSelectValues('', document.getElementById("semester")).trim();
    tempSubjectName = [];
    if (flag == "semester") {
        loadDataDropdown("subjectName", []);
        for (let i = 0; i < masterSubjectName.length; i++) {
            if (masterSubjectName[i].semester == tempSemester) {
                tempSubjectName.push(obj = {
                    "subjectId": masterSubjectName[i].subjectId.trim(),
                    "subjectName": masterSubjectName[i].subjectName.trim()
                });
            }
            loadDataDropdown("subjectName", tempSubjectName);
        }
        var table = $('#invoiceTable').DataTable();
        table.draw();
    }
    else if(flag == 'subject'){
        var table = $('#invoiceTable').DataTable();
        table.draw();
    }
}